import{s as Yn,o as Ln,n as ze}from"../chunks/scheduler.6062bdaf.js";import{S as Xn,i as Qn,g as h,s as a,r,A as En,h as d,f as n,c as l,j as Hn,u as o,x as m,k as Rn,y as An,a as s,v as p,d as g,t as f,w as u}from"../chunks/index.4bca734e.js";import{T as Se}from"../chunks/Tip.b9ac1f03.js";import{C as _}from"../chunks/CodeBlock.fa01571c.js";import{H as $,E as Fn}from"../chunks/EditOnGithub.74ab2baa.js";function Pn(j){let i,y=`<a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> is a Python client making HTTP calls to our APIs. If you want to make the HTTP calls directly using
your preferred tool (curl, postman,…), please refer to the <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a>
or to the <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a> documentation pages.`,c,b,C=`For web development, a <a href="https://huggingface.co/docs/huggingface.js/inference/README" rel="nofollow">JS client</a> has been released.
If you are interested in game development, you might have a look at our <a href="https://github.com/huggingface/unity-api" rel="nofollow">C# project</a>.`;return{c(){i=h("p"),i.innerHTML=y,c=a(),b=h("p"),b.innerHTML=C},l(w){i=d(w,"P",{"data-svelte-h":!0}),m(i)!=="svelte-vuvk1g"&&(i.innerHTML=y),c=l(w),b=d(w,"P",{"data-svelte-h":!0}),m(b)!=="svelte-22w7rm"&&(b.innerHTML=C)},m(w,M){s(w,i,M),s(w,c,M),s(w,b,M)},p:ze,d(w){w&&(n(i),n(c),n(b))}}}function Kn(j){let i,y=`The API is designed to be simple. Not all parameters and options are available or described for the end user. Check out
<a href="https://huggingface.co/docs/api-inference/detailed_parameters" rel="nofollow">this page</a> if you are interested in learning more about
all the parameters available for each task.`;return{c(){i=h("p"),i.innerHTML=y},l(c){i=d(c,"P",{"data-svelte-h":!0}),m(i)!=="svelte-1o4uc5e"&&(i.innerHTML=y)},m(c,b){s(c,i,b)},p:ze,d(c){c&&n(i)}}}function Dn(j){let i,y=`There are more than 200k models on the Hugging Face Hub! Each task in the <a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> comes with a recommended
model. Be aware that the HF recommendation can change over time without prior notice. Therefore it is best to explicitly
set a model once you are decided. Also, in most cases you’ll be interested in finding a model specific to <em>your</em> needs.
Visit the <a href="https://huggingface.co/models" rel="nofollow">Models</a> page on the Hub to explore your possibilities.`;return{c(){i=h("p"),i.innerHTML=y},l(c){i=d(c,"P",{"data-svelte-h":!0}),m(i)!=="svelte-70k57l"&&(i.innerHTML=y)},m(c,b){s(c,i,b)},p:ze,d(c){c&&n(i)}}}function On(j){let i,y=`Authentication is NOT mandatory when using the Inference API. However, authenticated users get a higher free-tier to
play with the service. Token is also mandatory if you want to run inference on your private models or on private
endpoints.`;return{c(){i=h("p"),i.textContent=y},l(c){i=d(c,"P",{"data-svelte-h":!0}),m(i)!=="svelte-7vtkgf"&&(i.textContent=y)},m(c,b){s(c,i,b)},p:ze,d(c){c&&n(i)}}}function es(j){let i,y=`Check out the <a href="https://huggingface.co/tasks" rel="nofollow">Tasks</a> page to learn more about each task, how to use them, and the
most popular models for each task.`;return{c(){i=h("p"),i.innerHTML=y},l(c){i=d(c,"P",{"data-svelte-h":!0}),m(i)!=="svelte-1u4hr1j"&&(i.innerHTML=y)},m(c,b){s(c,i,b)},p:ze,d(c){c&&n(i)}}}function ts(j){let i,y=`This is the recommended way to adapt your code to <a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>. It lets you benefit from the task-specific
methods like <code>feature_extraction</code>.`;return{c(){i=h("p"),i.innerHTML=y},l(c){i=d(c,"P",{"data-svelte-h":!0}),m(i)!=="svelte-e83rkg"&&(i.innerHTML=y)},m(c,b){s(c,i,b)},p:ze,d(c){c&&n(i)}}}function ns(j){let i,y,c,b,C,w,M,an=`Inference is the process of using a trained model to make predictions on new data. As this process can be compute-intensive,
running on a dedicated server can be an interesting option. The <code>huggingface_hub</code> library provides an easy way to call a
service that runs inference for hosted models. There are several services you can connect to:`,Re,v,ln=`<li><a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a>: a service that allows you to run accelerated inference
on Hugging Face’s infrastructure for free. This service is a fast way to get started, test different models, and
prototype AI products.</li> <li><a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a>: a product to easily deploy models to production.
Inference is run by Hugging Face in a dedicated, fully managed infrastructure on a cloud provider of your choice.</li>`,Ye,W,cn=`These services can be called with the <a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> object. It acts as a replacement for the legacy
<a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceApi">InferenceApi</a> client, adding specific support for tasks and handling inference on both
<a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a> and <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a>.
Learn how to migrate to the new client in the <a href="#legacy-inferenceapi-client">Legacy InferenceAPI client</a> section.`,Le,U,Xe,x,Qe,G,rn="Let’s get started with a text-to-image task:",Ee,V,Ae,q,on=`We initialized an <a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> with the default parameters. The only thing you need to know is the <a href="#supported-tasks">task</a> you want
to perform. By default, the client will connect to the Inference API and select a model to complete the task. In our
example, we generated an image from a text prompt. The returned value is a <code>PIL.Image</code> object that can be saved to a
file.`,Fe,I,Pe,N,Ke,B,pn="What if you want to use a specific model? You can specify it either as a parameter or directly at an instance level:",De,S,Oe,Z,et,z,tt,H,gn=`The examples we saw above use the Serverless Inference API. This proves to be very useful for prototyping
and testing things quickly. Once you’re ready to deploy your model to production, you’ll need to use a dedicated infrastructure.
That’s where <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a> comes into play. It allows you to deploy
any model and expose it as a private API. Once deployed, you’ll get a URL that you can connect to using exactly the same
code as before, changing only the <code>model</code> parameter:`,nt,R,st,Y,at,L,fn=`Calls made with the <a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> can be authenticated using a <a href="https://huggingface.co/docs/hub/security-tokens" rel="nofollow">User Access Token</a>.
By default, it will use the token saved on your machine if you are logged in (check out
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">how to authenticate</a>). If you are not logged in, you can pass
your token as an instance parameter:`,lt,X,it,k,ct,Q,rt,E,un=`<a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>’s goal is to provide the easiest interface to run inference on Hugging Face models. It
has a simple API that supports the most common tasks. Here is a list of the currently supported tasks:`,ot,A,hn='<thead><tr><th>Domain</th> <th>Task</th> <th>Supported</th> <th>Documentation</th></tr></thead> <tbody><tr><td>Audio</td> <td><a href="https://huggingface.co/tasks/audio-classification" rel="nofollow">Audio Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient.audio_classification">audio_classification()</a></td></tr> <tr><td>Audio</td> <td><a href="https://huggingface.co/tasks/audio-to-audio" rel="nofollow">Audio-to-Audio</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient.audio_to_audio">audio_to_audio()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/automatic-speech-recognition" rel="nofollow">Automatic Speech Recognition</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient.automatic_speech_recognition">automatic_speech_recognition()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-to-speech" rel="nofollow">Text-to-Speech</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_speech">text_to_speech()</a></td></tr> <tr><td>Computer Vision</td> <td><a href="https://huggingface.co/tasks/image-classification" rel="nofollow">Image Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_classification">image_classification()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/image-segmentation" rel="nofollow">Image Segmentation</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_segmentation">image_segmentation()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/image-to-image" rel="nofollow">Image-to-Image</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_to_image">image_to_image()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/image-to-text" rel="nofollow">Image-to-Text</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_to_text">image_to_text()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/object-detection" rel="nofollow">Object Detection</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient.object_detection">object_detection()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-to-image" rel="nofollow">Text-to-Image</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_image">text_to_image()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/zero-shot-image-classification" rel="nofollow">Zero-Shot-Image-Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient.zero_shot_image_classification">zero_shot_image_classification()</a></td></tr> <tr><td>Multimodal</td> <td><a href="https://huggingface.co/tasks/document-question-answering" rel="nofollow">Documentation Question Answering</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient.document_question_answering">document_question_answering()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/visual-question-answering" rel="nofollow">Visual Question Answering</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient.visual_question_answering">visual_question_answering()</a></td></tr> <tr><td>NLP</td> <td>Conversational</td> <td></td> <td><em>deprecated</em>, use Chat Completion</td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-generation" rel="nofollow">Chat Completion</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">chat_completion()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/feature-extraction" rel="nofollow">Feature Extraction</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient.feature_extraction">feature_extraction()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/fill-mask" rel="nofollow">Fill Mask</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient.fill_mask">fill_mask()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/question-answering" rel="nofollow">Question Answering</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient.question_answering">question_answering()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/sentence-similarity" rel="nofollow">Sentence Similarity</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient.sentence_similarity">sentence_similarity()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/summarization" rel="nofollow">Summarization</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient.summarization">summarization()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/table-question-answering" rel="nofollow">Table Question Answering</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient.table_question_answering">table_question_answering()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-classification" rel="nofollow">Text Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_classification">text_classification()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-generation" rel="nofollow">Text Generation</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_generation">text_generation()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/token-classification" rel="nofollow">Token Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient.token_classification">token_classification()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/translation" rel="nofollow">Translation</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient.translation">translation()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/zero-shot-classification" rel="nofollow">Zero Shot Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient.zero_shot_classification">zero_shot_classification()</a></td></tr> <tr><td>Tabular</td> <td><a href="https://huggingface.co/tasks/tabular-classification" rel="nofollow">Tabular Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient.tabular_classification">tabular_classification()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/tabular-regression" rel="nofollow">Tabular Regression</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient.tabular_regression">tabular_regression()</a></td></tr></tbody>',pt,T,gt,F,ft,P,dn=`However, it is not always possible to cover all use cases. For custom requests, the <a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient.post">InferenceClient.post()</a> method
gives you the flexibility to send any request to the Inference API. For example, you can specify how to parse the inputs
and outputs. In the example below, the generated image is returned as raw bytes instead of parsing it as a <code>PIL Image</code>.
This can be helpful if you don’t have <code>Pillow</code> installed in your setup and just care about the binary content of the
image. <a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient.post">InferenceClient.post()</a> is also useful to handle tasks that are not yet officially supported.`,ut,K,ht,D,dt,O,mn=`An async version of the client is also provided, based on <code>asyncio</code> and <code>aiohttp</code>. You can either install <code>aiohttp</code>
directly or use the <code>[inference]</code> extra:`,mt,ee,yt,te,yn=`After installation all async API endpoints are available via <a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a>. Its initialization and APIs are
strictly the same as the sync-only version.`,bt,ne,_t,se,bn='For more information about the <code>asyncio</code> module, please refer to the <a href="https://docs.python.org/3/library/asyncio.html" rel="nofollow">official documentation</a>.',$t,ae,jt,le,_n='In the above section, we saw the main aspects of <a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>. Let’s dive into some more advanced tips.',wt,ie,Mt,ce,$n="When doing inference, there are two main causes for a timeout:",Ct,re,jn="<li>The inference process takes a long time to complete.</li> <li>The model is not available, for example when Inference API is loading it for the first time.</li>",Ut,oe,wn=`<a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> has a global <code>timeout</code> parameter to handle those two aspects. By default, it is set to <code>None</code>,
meaning that the client will wait indefinitely for the inference to complete. If you want more control in your workflow,
you can set it to a specific value in seconds. If the timeout delay expires, an <a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError">InferenceTimeoutError</a> is raised.
You can catch it and handle it in your code:`,It,pe,Zt,ge,kt,fe,Mn=`Some tasks require binary inputs, for example, when dealing with images or audio files. In this case, <a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
tries to be as permissive as possible and accept different types:`,Tt,ue,Cn=`<li>raw <code>bytes</code></li> <li>a file-like object, opened as binary (<code>with open(&quot;audio.flac&quot;, &quot;rb&quot;) as f: ...</code>)</li> <li>a path (<code>str</code> or <code>Path</code>) pointing to a local file</li> <li>a URL (<code>str</code>) pointing to a remote file (e.g. <code>https://...</code>). In this case, the file will be downloaded locally before
sending it to the Inference API.</li>`,Jt,he,vt,de,Wt,me,Un=`<a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> acts as a replacement for the legacy <a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceApi">InferenceApi</a> client. It adds specific support for tasks and
handles inference on both <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a> and <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a>.`,xt,ye,In='Here is a short guide to help you migrate from <a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceApi">InferenceApi</a> to <a href="/docs/huggingface_hub/pr_2322/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>.',Gt,be,Vt,_e,Zn="Change from",qt,$e,Nt,je,kn="to",Bt,we,St,Me,zt,Ce,Tn="Change from",Ht,Ue,Rt,Ie,Jn="to",Yt,Ze,Lt,J,Xt,ke,Qt,Te,vn="Change from",Et,Je,At,ve,Wn="to",Ft,We,Pt,xe,Kt,Ge,xn="Change from",Dt,Ve,Ot,qe,Gn="to",en,Ne,tn,Be,nn,He,sn;return C=new $({props:{title:"Run Inference on servers",local:"run-inference-on-servers",headingTag:"h1"}}),U=new Se({props:{$$slots:{default:[Pn]},$$scope:{ctx:j}}}),x=new $({props:{title:"Getting started",local:"getting-started",headingTag:"h2"}}),V=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)`,wrap:!1}}),I=new Se({props:{warning:!0,$$slots:{default:[Kn]},$$scope:{ctx:j}}}),N=new $({props:{title:"Using a specific model",local:"using-a-specific-model",headingTag:"h3"}}),S=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMnByb21wdGhlcm8lMkZvcGVuam91cm5leS12NCUyMiklMEFjbGllbnQudGV4dF90b19pbWFnZSguLi4pJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCklMEFjbGllbnQudGV4dF90b19pbWFnZSguLi4lMkMlMjBtb2RlbCUzRCUyMnByb21wdGhlcm8lMkZvcGVuam91cm5leS12NCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-comment"># Initialize client for a specific model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(model=<span class="hljs-string">&quot;prompthero/openjourney-v4&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(...)
<span class="hljs-comment"># Or use a generic client but pass your model as an argument</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(..., model=<span class="hljs-string">&quot;prompthero/openjourney-v4&quot;</span>)`,wrap:!1}}),Z=new Se({props:{$$slots:{default:[Dn]},$$scope:{ctx:j}}}),z=new $({props:{title:"Using a specific URL",local:"using-a-specific-url",headingTag:"h3"}}),R=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMmh0dHBzJTNBJTJGJTJGdXUxNDlyZXo2Z3c5ZWhlai5ldS13ZXN0LTEuYXdzLmVuZHBvaW50cy5odWdnaW5nZmFjZS5jbG91ZCUyRmRlZXBmbG95ZC1pZiUyMiklMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoKSUwQWNsaWVudC50ZXh0X3RvX2ltYWdlKC4uLiUyQyUyMG1vZGVsJTNEJTIyaHR0cHMlM0ElMkYlMkZ1dTE0OXJlejZndzllaGVqLmV1LXdlc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGZGVlcGZsb3lkLWlmJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(model=<span class="hljs-string">&quot;https://uu149rez6gw9ehej.eu-west-1.aws.endpoints.huggingface.cloud/deepfloyd-if&quot;</span>)
<span class="hljs-comment"># or</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(..., model=<span class="hljs-string">&quot;https://uu149rez6gw9ehej.eu-west-1.aws.endpoints.huggingface.cloud/deepfloyd-if&quot;</span>)`,wrap:!1}}),Y=new $({props:{title:"Authentication",local:"authentication",headingTag:"h3"}}),X=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCh0b2tlbiUzRCUyMmhmXyoqKiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(token=<span class="hljs-string">&quot;hf_***&quot;</span>)`,wrap:!1}}),k=new Se({props:{$$slots:{default:[On]},$$scope:{ctx:j}}}),Q=new $({props:{title:"Supported tasks",local:"supported-tasks",headingTag:"h2"}}),T=new Se({props:{$$slots:{default:[es]},$$scope:{ctx:j}}}),F=new $({props:{title:"Custom requests",local:"custom-requests",headingTag:"h2"}}),K=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBcmVzcG9uc2UlMjAlM0QlMjBjbGllbnQucG9zdChqc29uJTNEJTdCJTIyaW5wdXRzJTIyJTNBJTIwJTIyQW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMHRoZSUyMG1vb24uJTIyJTdEJTJDJTIwbW9kZWwlM0QlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi0xJTIyKSUwQXJlc3BvbnNlLmNvbnRlbnQlMjAlMjMlMjByYXclMjBieXRlcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>}, model=<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.content <span class="hljs-comment"># raw bytes</span>
<span class="hljs-string">b&#x27;...&#x27;</span>`,wrap:!1}}),D=new $({props:{title:"Async client",local:"async-client",headingTag:"h2"}}),ee=new _({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMGh1Z2dpbmdmYWNlX2h1YiU1QmluZmVyZW5jZSU1RCUwQSUyMyUyMG9yJTBBJTIzJTIwcGlwJTIwaW5zdGFsbCUyMGFpb2h0dHA=",highlighted:`pip install --upgrade huggingface_hub[inference]
<span class="hljs-comment"># or</span>
<span class="hljs-comment"># pip install aiohttp</span>`,wrap:!1}}),ne=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUwQSUwQWFzeW5jJTIwZm9yJTIwdG9rZW4lMjBpbiUyMGF3YWl0JTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMjJUaGUlMjBIdWdnaW5nZmFjZSUyMEh1YiUyMGlzJTIyJTJDJTIwc3RyZWFtJTNEVHJ1ZSklM0ElMEElMjAlMjAlMjAlMjBwcmludCh0b2tlbiUyQyUyMGVuZCUzRCUyMiUyMik=",highlighted:`<span class="hljs-comment"># Code must be run in a asyncio concurrent context.</span>
<span class="hljs-comment"># $ python -m asyncio</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The Huggingface Hub is&quot;</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token, end=<span class="hljs-string">&quot;&quot;</span>)
 a platform <span class="hljs-keyword">for</span> sharing <span class="hljs-keyword">and</span> discussing ML-related content.`,wrap:!1}}),ae=new $({props:{title:"Advanced tips",local:"advanced-tips",headingTag:"h2"}}),ie=new $({props:{title:"Timeout",local:"timeout",headingTag:"h3"}}),pe=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUyQyUyMEluZmVyZW5jZVRpbWVvdXRFcnJvciUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCh0aW1lb3V0JTNEMzApJTBBdHJ5JTNBJTBBJTIwJTIwJTIwJTIwY2xpZW50LnRleHRfdG9faW1hZ2UoLi4uKSUwQWV4Y2VwdCUyMEluZmVyZW5jZVRpbWVvdXRFcnJvciUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkluZmVyZW5jZSUyMHRpbWVkJTIwb3V0JTIwYWZ0ZXIlMjAzMHMuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient, InferenceTimeoutError
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(timeout=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">try</span>:
<span class="hljs-meta">... </span>    client.text_to_image(...)
<span class="hljs-meta">... </span><span class="hljs-keyword">except</span> InferenceTimeoutError:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Inference timed out after 30s.&quot;</span>)`,wrap:!1}}),ge=new $({props:{title:"Binary inputs",local:"binary-inputs",headingTag:"h3"}}),he=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX2NsYXNzaWZpY2F0aW9uKCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_classification(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9779096841812134</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Blenheim spaniel&#x27;</span>}, ...]`,wrap:!1}}),de=new $({props:{title:"Legacy InferenceAPI client",local:"legacy-inferenceapi-client",headingTag:"h2"}}),be=new $({props:{title:"Initialization",local:"initialization",headingTag:"h3"}}),$e=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUFwaSUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUFwaShyZXBvX2lkJTNEJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMkMlMjB0b2tlbiUzREFQSV9UT0tFTik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceApi
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(repo_id=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, token=API_TOKEN)`,wrap:!1}}),we=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyJTJDJTIwdG9rZW4lM0RBUElfVE9LRU4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceClient(model=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, token=API_TOKEN)`,wrap:!1}}),Me=new $({props:{title:"Run on a specific task",local:"run-on-a-specific-task",headingTag:"h3"}}),Ue=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUFwaSUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUFwaShyZXBvX2lkJTNEJTIycGFyYXBocmFzZS14bG0tci1tdWx0aWxpbmd1YWwtdjElMjIlMkMlMjB0YXNrJTNEJTIyZmVhdHVyZS1leHRyYWN0aW9uJTIyKSUwQWluZmVyZW5jZSguLi4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceApi
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(repo_id=<span class="hljs-string">&quot;paraphrase-xlm-r-multilingual-v1&quot;</span>, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(...)`,wrap:!1}}),Ze=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBaW5mZXJlbmNlLmZlYXR1cmVfZXh0cmFjdGlvbiguLi4lMkMlMjBtb2RlbCUzRCUyMnBhcmFwaHJhc2UteGxtLXItbXVsdGlsaW5ndWFsLXYxJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>inference.feature_extraction(..., model=<span class="hljs-string">&quot;paraphrase-xlm-r-multilingual-v1&quot;</span>)`,wrap:!1}}),J=new Se({props:{$$slots:{default:[ts]},$$scope:{ctx:j}}}),ke=new $({props:{title:"Run custom request",local:"run-custom-request",headingTag:"h3"}}),Je=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUFwaSUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUFwaShyZXBvX2lkJTNEJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBaW5mZXJlbmNlKGlucHV0cyUzRCUyMlRoZSUyMGdvYWwlMjBvZiUyMGxpZmUlMjBpcyUyMCU1Qk1BU0slNUQuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceApi
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(repo_id=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs=<span class="hljs-string">&quot;The goal of life is [MASK].&quot;</span>)
[{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;the goal of life is life.&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.10933292657136917</span>, <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">2166</span>, <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;life&#x27;</span>}]`,wrap:!1}}),We=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBcmVzcG9uc2UlMjAlM0QlMjBjbGllbnQucG9zdChqc29uJTNEJTdCJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhlJTIwZ29hbCUyMG9mJTIwbGlmZSUyMGlzJTIwJTVCTUFTSyU1RC4lMjIlN0QlMkMlMjBtb2RlbCUzRCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSUwQXJlc3BvbnNlLmpzb24oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;The goal of life is [MASK].&quot;</span>}, model=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.json()
[{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;the goal of life is life.&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.10933292657136917</span>, <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">2166</span>, <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;life&#x27;</span>}]`,wrap:!1}}),xe=new $({props:{title:"Run with parameters",local:"run-with-parameters",headingTag:"h3"}}),Ve=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUFwaSUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUFwaShyZXBvX2lkJTNEJTIydHlwZWZvcm0lMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1tbmxpJTIyKSUwQWlucHV0cyUyMCUzRCUyMCUyMkhpJTJDJTIwSSUyMHJlY2VudGx5JTIwYm91Z2h0JTIwYSUyMGRldmljZSUyMGZyb20lMjB5b3VyJTIwY29tcGFueSUyMGJ1dCUyMGl0JTIwaXMlMjBub3QlMjB3b3JraW5nJTIwYXMlMjBhZHZlcnRpc2VkJTIwYW5kJTIwSSUyMHdvdWxkJTIwbGlrZSUyMHRvJTIwZ2V0JTIwcmVpbWJ1cnNlZCElMjIlMEFwYXJhbXMlMjAlM0QlMjAlN0IlMjJjYW5kaWRhdGVfbGFiZWxzJTIyJTNBJTVCJTIycmVmdW5kJTIyJTJDJTIwJTIybGVnYWwlMjIlMkMlMjAlMjJmYXElMjIlNUQlN0QlMEFpbmZlcmVuY2UoaW5wdXRzJTJDJTIwcGFyYW1zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceApi
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(repo_id=<span class="hljs-string">&quot;typeform/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-string">&quot;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = {<span class="hljs-string">&quot;candidate_labels&quot;</span>:[<span class="hljs-string">&quot;refund&quot;</span>, <span class="hljs-string">&quot;legal&quot;</span>, <span class="hljs-string">&quot;faq&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs, params)
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.9378499388694763</span>, <span class="hljs-number">0.04914155602455139</span>, <span class="hljs-number">0.013008488342165947</span>]}`,wrap:!1}}),Ne=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBaW5wdXRzJTIwJTNEJTIwJTIySGklMkMlMjBJJTIwcmVjZW50bHklMjBib3VnaHQlMjBhJTIwZGV2aWNlJTIwZnJvbSUyMHlvdXIlMjBjb21wYW55JTIwYnV0JTIwaXQlMjBpcyUyMG5vdCUyMHdvcmtpbmclMjBhcyUyMGFkdmVydGlzZWQlMjBhbmQlMjBJJTIwd291bGQlMjBsaWtlJTIwdG8lMjBnZXQlMjByZWltYnVyc2VkISUyMiUwQXBhcmFtcyUyMCUzRCUyMCU3QiUyMmNhbmRpZGF0ZV9sYWJlbHMlMjIlM0ElNUIlMjJyZWZ1bmQlMjIlMkMlMjAlMjJsZWdhbCUyMiUyQyUyMCUyMmZhcSUyMiU1RCU3RCUwQXJlc3BvbnNlJTIwJTNEJTIwY2xpZW50LnBvc3QoanNvbiUzRCU3QiUyMmlucHV0cyUyMiUzQSUyMGlucHV0cyUyQyUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjBwYXJhbXMlN0QlMkMlMjBtb2RlbCUzRCUyMnR5cGVmb3JtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtbW5saSUyMiklMEFyZXNwb25zZS5qc29uKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-string">&quot;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = {<span class="hljs-string">&quot;candidate_labels&quot;</span>:[<span class="hljs-string">&quot;refund&quot;</span>, <span class="hljs-string">&quot;legal&quot;</span>, <span class="hljs-string">&quot;faq&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: inputs, <span class="hljs-string">&quot;parameters&quot;</span>: params}, model=<span class="hljs-string">&quot;typeform/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.json()
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.9378499388694763</span>, <span class="hljs-number">0.04914155602455139</span>, <span class="hljs-number">0.013008488342165947</span>]}`,wrap:!1}}),Be=new Fn({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/inference.md"}}),{c(){i=h("meta"),y=a(),c=h("p"),b=a(),r(C.$$.fragment),w=a(),M=h("p"),M.innerHTML=an,Re=a(),v=h("ul"),v.innerHTML=ln,Ye=a(),W=h("p"),W.innerHTML=cn,Le=a(),r(U.$$.fragment),Xe=a(),r(x.$$.fragment),Qe=a(),G=h("p"),G.textContent=rn,Ee=a(),r(V.$$.fragment),Ae=a(),q=h("p"),q.innerHTML=on,Fe=a(),r(I.$$.fragment),Pe=a(),r(N.$$.fragment),Ke=a(),B=h("p"),B.textContent=pn,De=a(),r(S.$$.fragment),Oe=a(),r(Z.$$.fragment),et=a(),r(z.$$.fragment),tt=a(),H=h("p"),H.innerHTML=gn,nt=a(),r(R.$$.fragment),st=a(),r(Y.$$.fragment),at=a(),L=h("p"),L.innerHTML=fn,lt=a(),r(X.$$.fragment),it=a(),r(k.$$.fragment),ct=a(),r(Q.$$.fragment),rt=a(),E=h("p"),E.innerHTML=un,ot=a(),A=h("table"),A.innerHTML=hn,pt=a(),r(T.$$.fragment),gt=a(),r(F.$$.fragment),ft=a(),P=h("p"),P.innerHTML=dn,ut=a(),r(K.$$.fragment),ht=a(),r(D.$$.fragment),dt=a(),O=h("p"),O.innerHTML=mn,mt=a(),r(ee.$$.fragment),yt=a(),te=h("p"),te.innerHTML=yn,bt=a(),r(ne.$$.fragment),_t=a(),se=h("p"),se.innerHTML=bn,$t=a(),r(ae.$$.fragment),jt=a(),le=h("p"),le.innerHTML=_n,wt=a(),r(ie.$$.fragment),Mt=a(),ce=h("p"),ce.textContent=$n,Ct=a(),re=h("ul"),re.innerHTML=jn,Ut=a(),oe=h("p"),oe.innerHTML=wn,It=a(),r(pe.$$.fragment),Zt=a(),r(ge.$$.fragment),kt=a(),fe=h("p"),fe.innerHTML=Mn,Tt=a(),ue=h("ul"),ue.innerHTML=Cn,Jt=a(),r(he.$$.fragment),vt=a(),r(de.$$.fragment),Wt=a(),me=h("p"),me.innerHTML=Un,xt=a(),ye=h("p"),ye.innerHTML=In,Gt=a(),r(be.$$.fragment),Vt=a(),_e=h("p"),_e.textContent=Zn,qt=a(),r($e.$$.fragment),Nt=a(),je=h("p"),je.textContent=kn,Bt=a(),r(we.$$.fragment),St=a(),r(Me.$$.fragment),zt=a(),Ce=h("p"),Ce.textContent=Tn,Ht=a(),r(Ue.$$.fragment),Rt=a(),Ie=h("p"),Ie.textContent=Jn,Yt=a(),r(Ze.$$.fragment),Lt=a(),r(J.$$.fragment),Xt=a(),r(ke.$$.fragment),Qt=a(),Te=h("p"),Te.textContent=vn,Et=a(),r(Je.$$.fragment),At=a(),ve=h("p"),ve.textContent=Wn,Ft=a(),r(We.$$.fragment),Pt=a(),r(xe.$$.fragment),Kt=a(),Ge=h("p"),Ge.textContent=xn,Dt=a(),r(Ve.$$.fragment),Ot=a(),qe=h("p"),qe.textContent=Gn,en=a(),r(Ne.$$.fragment),tn=a(),r(Be.$$.fragment),nn=a(),He=h("p"),this.h()},l(e){const t=En("svelte-u9bgzb",document.head);i=d(t,"META",{name:!0,content:!0}),t.forEach(n),y=l(e),c=d(e,"P",{}),Hn(c).forEach(n),b=l(e),o(C.$$.fragment,e),w=l(e),M=d(e,"P",{"data-svelte-h":!0}),m(M)!=="svelte-411gzg"&&(M.innerHTML=an),Re=l(e),v=d(e,"UL",{"data-svelte-h":!0}),m(v)!=="svelte-lzzf1y"&&(v.innerHTML=ln),Ye=l(e),W=d(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-hmaupz"&&(W.innerHTML=cn),Le=l(e),o(U.$$.fragment,e),Xe=l(e),o(x.$$.fragment,e),Qe=l(e),G=d(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-8lplub"&&(G.textContent=rn),Ee=l(e),o(V.$$.fragment,e),Ae=l(e),q=d(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-1gyv7dn"&&(q.innerHTML=on),Fe=l(e),o(I.$$.fragment,e),Pe=l(e),o(N.$$.fragment,e),Ke=l(e),B=d(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1npu22n"&&(B.textContent=pn),De=l(e),o(S.$$.fragment,e),Oe=l(e),o(Z.$$.fragment,e),et=l(e),o(z.$$.fragment,e),tt=l(e),H=d(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-cp0irx"&&(H.innerHTML=gn),nt=l(e),o(R.$$.fragment,e),st=l(e),o(Y.$$.fragment,e),at=l(e),L=d(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-1p94zud"&&(L.innerHTML=fn),lt=l(e),o(X.$$.fragment,e),it=l(e),o(k.$$.fragment,e),ct=l(e),o(Q.$$.fragment,e),rt=l(e),E=d(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1pp7zzx"&&(E.innerHTML=un),ot=l(e),A=d(e,"TABLE",{"data-svelte-h":!0}),m(A)!=="svelte-1huavug"&&(A.innerHTML=hn),pt=l(e),o(T.$$.fragment,e),gt=l(e),o(F.$$.fragment,e),ft=l(e),P=d(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-12vjetc"&&(P.innerHTML=dn),ut=l(e),o(K.$$.fragment,e),ht=l(e),o(D.$$.fragment,e),dt=l(e),O=d(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-1gqwj00"&&(O.innerHTML=mn),mt=l(e),o(ee.$$.fragment,e),yt=l(e),te=d(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-1bl988d"&&(te.innerHTML=yn),bt=l(e),o(ne.$$.fragment,e),_t=l(e),se=d(e,"P",{"data-svelte-h":!0}),m(se)!=="svelte-q492az"&&(se.innerHTML=bn),$t=l(e),o(ae.$$.fragment,e),jt=l(e),le=d(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-1biyoo4"&&(le.innerHTML=_n),wt=l(e),o(ie.$$.fragment,e),Mt=l(e),ce=d(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-8gznjs"&&(ce.textContent=$n),Ct=l(e),re=d(e,"UL",{"data-svelte-h":!0}),m(re)!=="svelte-ovc80h"&&(re.innerHTML=jn),Ut=l(e),oe=d(e,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-plre42"&&(oe.innerHTML=wn),It=l(e),o(pe.$$.fragment,e),Zt=l(e),o(ge.$$.fragment,e),kt=l(e),fe=d(e,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-jzlxv8"&&(fe.innerHTML=Mn),Tt=l(e),ue=d(e,"UL",{"data-svelte-h":!0}),m(ue)!=="svelte-vaeuct"&&(ue.innerHTML=Cn),Jt=l(e),o(he.$$.fragment,e),vt=l(e),o(de.$$.fragment,e),Wt=l(e),me=d(e,"P",{"data-svelte-h":!0}),m(me)!=="svelte-zz7nwv"&&(me.innerHTML=Un),xt=l(e),ye=d(e,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-1c757h2"&&(ye.innerHTML=In),Gt=l(e),o(be.$$.fragment,e),Vt=l(e),_e=d(e,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-ft9vbs"&&(_e.textContent=Zn),qt=l(e),o($e.$$.fragment,e),Nt=l(e),je=d(e,"P",{"data-svelte-h":!0}),m(je)!=="svelte-8wg17z"&&(je.textContent=kn),Bt=l(e),o(we.$$.fragment,e),St=l(e),o(Me.$$.fragment,e),zt=l(e),Ce=d(e,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-ft9vbs"&&(Ce.textContent=Tn),Ht=l(e),o(Ue.$$.fragment,e),Rt=l(e),Ie=d(e,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-8wg17z"&&(Ie.textContent=Jn),Yt=l(e),o(Ze.$$.fragment,e),Lt=l(e),o(J.$$.fragment,e),Xt=l(e),o(ke.$$.fragment,e),Qt=l(e),Te=d(e,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-ft9vbs"&&(Te.textContent=vn),Et=l(e),o(Je.$$.fragment,e),At=l(e),ve=d(e,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-8wg17z"&&(ve.textContent=Wn),Ft=l(e),o(We.$$.fragment,e),Pt=l(e),o(xe.$$.fragment,e),Kt=l(e),Ge=d(e,"P",{"data-svelte-h":!0}),m(Ge)!=="svelte-ft9vbs"&&(Ge.textContent=xn),Dt=l(e),o(Ve.$$.fragment,e),Ot=l(e),qe=d(e,"P",{"data-svelte-h":!0}),m(qe)!=="svelte-8wg17z"&&(qe.textContent=Gn),en=l(e),o(Ne.$$.fragment,e),tn=l(e),o(Be.$$.fragment,e),nn=l(e),He=d(e,"P",{}),Hn(He).forEach(n),this.h()},h(){Rn(i,"name","hf:doc:metadata"),Rn(i,"content",ss)},m(e,t){An(document.head,i),s(e,y,t),s(e,c,t),s(e,b,t),p(C,e,t),s(e,w,t),s(e,M,t),s(e,Re,t),s(e,v,t),s(e,Ye,t),s(e,W,t),s(e,Le,t),p(U,e,t),s(e,Xe,t),p(x,e,t),s(e,Qe,t),s(e,G,t),s(e,Ee,t),p(V,e,t),s(e,Ae,t),s(e,q,t),s(e,Fe,t),p(I,e,t),s(e,Pe,t),p(N,e,t),s(e,Ke,t),s(e,B,t),s(e,De,t),p(S,e,t),s(e,Oe,t),p(Z,e,t),s(e,et,t),p(z,e,t),s(e,tt,t),s(e,H,t),s(e,nt,t),p(R,e,t),s(e,st,t),p(Y,e,t),s(e,at,t),s(e,L,t),s(e,lt,t),p(X,e,t),s(e,it,t),p(k,e,t),s(e,ct,t),p(Q,e,t),s(e,rt,t),s(e,E,t),s(e,ot,t),s(e,A,t),s(e,pt,t),p(T,e,t),s(e,gt,t),p(F,e,t),s(e,ft,t),s(e,P,t),s(e,ut,t),p(K,e,t),s(e,ht,t),p(D,e,t),s(e,dt,t),s(e,O,t),s(e,mt,t),p(ee,e,t),s(e,yt,t),s(e,te,t),s(e,bt,t),p(ne,e,t),s(e,_t,t),s(e,se,t),s(e,$t,t),p(ae,e,t),s(e,jt,t),s(e,le,t),s(e,wt,t),p(ie,e,t),s(e,Mt,t),s(e,ce,t),s(e,Ct,t),s(e,re,t),s(e,Ut,t),s(e,oe,t),s(e,It,t),p(pe,e,t),s(e,Zt,t),p(ge,e,t),s(e,kt,t),s(e,fe,t),s(e,Tt,t),s(e,ue,t),s(e,Jt,t),p(he,e,t),s(e,vt,t),p(de,e,t),s(e,Wt,t),s(e,me,t),s(e,xt,t),s(e,ye,t),s(e,Gt,t),p(be,e,t),s(e,Vt,t),s(e,_e,t),s(e,qt,t),p($e,e,t),s(e,Nt,t),s(e,je,t),s(e,Bt,t),p(we,e,t),s(e,St,t),p(Me,e,t),s(e,zt,t),s(e,Ce,t),s(e,Ht,t),p(Ue,e,t),s(e,Rt,t),s(e,Ie,t),s(e,Yt,t),p(Ze,e,t),s(e,Lt,t),p(J,e,t),s(e,Xt,t),p(ke,e,t),s(e,Qt,t),s(e,Te,t),s(e,Et,t),p(Je,e,t),s(e,At,t),s(e,ve,t),s(e,Ft,t),p(We,e,t),s(e,Pt,t),p(xe,e,t),s(e,Kt,t),s(e,Ge,t),s(e,Dt,t),p(Ve,e,t),s(e,Ot,t),s(e,qe,t),s(e,en,t),p(Ne,e,t),s(e,tn,t),p(Be,e,t),s(e,nn,t),s(e,He,t),sn=!0},p(e,[t]){const Vn={};t&2&&(Vn.$$scope={dirty:t,ctx:e}),U.$set(Vn);const qn={};t&2&&(qn.$$scope={dirty:t,ctx:e}),I.$set(qn);const Nn={};t&2&&(Nn.$$scope={dirty:t,ctx:e}),Z.$set(Nn);const Bn={};t&2&&(Bn.$$scope={dirty:t,ctx:e}),k.$set(Bn);const Sn={};t&2&&(Sn.$$scope={dirty:t,ctx:e}),T.$set(Sn);const zn={};t&2&&(zn.$$scope={dirty:t,ctx:e}),J.$set(zn)},i(e){sn||(g(C.$$.fragment,e),g(U.$$.fragment,e),g(x.$$.fragment,e),g(V.$$.fragment,e),g(I.$$.fragment,e),g(N.$$.fragment,e),g(S.$$.fragment,e),g(Z.$$.fragment,e),g(z.$$.fragment,e),g(R.$$.fragment,e),g(Y.$$.fragment,e),g(X.$$.fragment,e),g(k.$$.fragment,e),g(Q.$$.fragment,e),g(T.$$.fragment,e),g(F.$$.fragment,e),g(K.$$.fragment,e),g(D.$$.fragment,e),g(ee.$$.fragment,e),g(ne.$$.fragment,e),g(ae.$$.fragment,e),g(ie.$$.fragment,e),g(pe.$$.fragment,e),g(ge.$$.fragment,e),g(he.$$.fragment,e),g(de.$$.fragment,e),g(be.$$.fragment,e),g($e.$$.fragment,e),g(we.$$.fragment,e),g(Me.$$.fragment,e),g(Ue.$$.fragment,e),g(Ze.$$.fragment,e),g(J.$$.fragment,e),g(ke.$$.fragment,e),g(Je.$$.fragment,e),g(We.$$.fragment,e),g(xe.$$.fragment,e),g(Ve.$$.fragment,e),g(Ne.$$.fragment,e),g(Be.$$.fragment,e),sn=!0)},o(e){f(C.$$.fragment,e),f(U.$$.fragment,e),f(x.$$.fragment,e),f(V.$$.fragment,e),f(I.$$.fragment,e),f(N.$$.fragment,e),f(S.$$.fragment,e),f(Z.$$.fragment,e),f(z.$$.fragment,e),f(R.$$.fragment,e),f(Y.$$.fragment,e),f(X.$$.fragment,e),f(k.$$.fragment,e),f(Q.$$.fragment,e),f(T.$$.fragment,e),f(F.$$.fragment,e),f(K.$$.fragment,e),f(D.$$.fragment,e),f(ee.$$.fragment,e),f(ne.$$.fragment,e),f(ae.$$.fragment,e),f(ie.$$.fragment,e),f(pe.$$.fragment,e),f(ge.$$.fragment,e),f(he.$$.fragment,e),f(de.$$.fragment,e),f(be.$$.fragment,e),f($e.$$.fragment,e),f(we.$$.fragment,e),f(Me.$$.fragment,e),f(Ue.$$.fragment,e),f(Ze.$$.fragment,e),f(J.$$.fragment,e),f(ke.$$.fragment,e),f(Je.$$.fragment,e),f(We.$$.fragment,e),f(xe.$$.fragment,e),f(Ve.$$.fragment,e),f(Ne.$$.fragment,e),f(Be.$$.fragment,e),sn=!1},d(e){e&&(n(y),n(c),n(b),n(w),n(M),n(Re),n(v),n(Ye),n(W),n(Le),n(Xe),n(Qe),n(G),n(Ee),n(Ae),n(q),n(Fe),n(Pe),n(Ke),n(B),n(De),n(Oe),n(et),n(tt),n(H),n(nt),n(st),n(at),n(L),n(lt),n(it),n(ct),n(rt),n(E),n(ot),n(A),n(pt),n(gt),n(ft),n(P),n(ut),n(ht),n(dt),n(O),n(mt),n(yt),n(te),n(bt),n(_t),n(se),n($t),n(jt),n(le),n(wt),n(Mt),n(ce),n(Ct),n(re),n(Ut),n(oe),n(It),n(Zt),n(kt),n(fe),n(Tt),n(ue),n(Jt),n(vt),n(Wt),n(me),n(xt),n(ye),n(Gt),n(Vt),n(_e),n(qt),n(Nt),n(je),n(Bt),n(St),n(zt),n(Ce),n(Ht),n(Rt),n(Ie),n(Yt),n(Lt),n(Xt),n(Qt),n(Te),n(Et),n(At),n(ve),n(Ft),n(Pt),n(Kt),n(Ge),n(Dt),n(Ot),n(qe),n(en),n(tn),n(nn),n(He)),n(i),u(C,e),u(U,e),u(x,e),u(V,e),u(I,e),u(N,e),u(S,e),u(Z,e),u(z,e),u(R,e),u(Y,e),u(X,e),u(k,e),u(Q,e),u(T,e),u(F,e),u(K,e),u(D,e),u(ee,e),u(ne,e),u(ae,e),u(ie,e),u(pe,e),u(ge,e),u(he,e),u(de,e),u(be,e),u($e,e),u(we,e),u(Me,e),u(Ue,e),u(Ze,e),u(J,e),u(ke,e),u(Je,e),u(We,e),u(xe,e),u(Ve,e),u(Ne,e),u(Be,e)}}}const ss='{"title":"Run Inference on servers","local":"run-inference-on-servers","sections":[{"title":"Getting started","local":"getting-started","sections":[{"title":"Using a specific model","local":"using-a-specific-model","sections":[],"depth":3},{"title":"Using a specific URL","local":"using-a-specific-url","sections":[],"depth":3},{"title":"Authentication","local":"authentication","sections":[],"depth":3}],"depth":2},{"title":"Supported tasks","local":"supported-tasks","sections":[],"depth":2},{"title":"Custom requests","local":"custom-requests","sections":[],"depth":2},{"title":"Async client","local":"async-client","sections":[],"depth":2},{"title":"Advanced tips","local":"advanced-tips","sections":[{"title":"Timeout","local":"timeout","sections":[],"depth":3},{"title":"Binary inputs","local":"binary-inputs","sections":[],"depth":3}],"depth":2},{"title":"Legacy InferenceAPI client","local":"legacy-inferenceapi-client","sections":[{"title":"Initialization","local":"initialization","sections":[],"depth":3},{"title":"Run on a specific task","local":"run-on-a-specific-task","sections":[],"depth":3},{"title":"Run custom request","local":"run-custom-request","sections":[],"depth":3},{"title":"Run with parameters","local":"run-with-parameters","sections":[],"depth":3}],"depth":2}],"depth":1}';function as(j){return Ln(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ps extends Xn{constructor(i){super(),Qn(this,i,as,ns,Yn,{})}}export{ps as component};
