import{s as Xs,n as Zs,o as se}from"../chunks/scheduler.7bc62968.js";import{S as ee,i as te,g as l,s as n,r as q,m as As,H as Bs,A as ae,h as r,f as t,c as i,j as V,u as j,x as o,n as ks,B as Js,k as Ks,y as m,a,v as W,d as O,t as R,w as U}from"../chunks/index.2f8492b0.js";import{H as Q,E as ne}from"../chunks/EditOnGithub.2a9ce03a.js";function ie(Cs){let c,Y,F,X,u,Z,f,ss,v,Es='Generative Adversarial Networks (GANs) are a class of deep learning models introduced by <a href="https://scholar.google.ca/citations?user=iYN86KEAAAAJ&amp;hl=en" rel="nofollow">Ian Goodfellow</a> and his colleagues in 2014. The core idea behind GANs is to train a generator network to produce data that is indistinguishable from real data, while simultaneously training a discriminator network to differentiate between real and generated data.',es,p,E,Ms="<strong>Architecture overview:</strong> GANs consist of two main components: <code>the generator</code> and <code>the discriminator</code>.",_s,g,M,Ns="Generator:",$s,ts,Qs='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>z</mi></mrow><annotation encoding="application/x-tex">z</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.4306em;"></span><span class="mord mathnormal" style="margin-right:0.04398em;">z</span></span></span></span>',as,Gs,N,Hs="<strong>Discriminator:</strong> The discriminator, akin to a detective, evaluates whether a given sample is real (from the actual dataset) or fake (generated by the generator). Its objective is to become increasingly accurate in distinguishing between real and generated samples.",ns,y,Is="A common analogy that can be found online is that of an art forger/painter (the generator) which tries to forge paintings and an art investigator/critic (the discriminator) which tries to detect limitations.",is,b,Ds='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/generative_models/GAN.png" alt="Lilian Weng GAN Figure"/>',ls,w,rs,x,Ps="GANs and VAEs are both popular generative models in machine learning, but they have different strengths and weaknesses. Whether one is “better” depends on the specific task and requirements. Here’s a breakdown of their strengths and weaknesses.",ms,A,Ss=`<li><strong>Image Generation:</strong><ul><li><strong>GANs:</strong><ul><li><strong>Strengths:</strong> Generate higher quality images, especially for complex data with sharp details and realistic textures.</li> <li><strong>Weaknesses:</strong> Can be more difficult to train and prone to instability.</li> <li><strong>Example:</strong> A GAN-generated image of a bedroom is likely to be indistinguishable from a real one, while a VAE-generated bedroom might appear blurry or have unrealistic lighting.
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/generative_models/bedroom.png" alt="Example of GAN-Generated bedrooms taken from Unsupervised Representation Learning with Deep Convolutional Generative Adversarial Networks, 2015"/></li></ul></li> <li><strong>VAEs:</strong><ul><li><strong>Strengths:</strong> Easier to train and more stable than GANs.</li> <li><strong>Weaknesses:</strong> May generate blurry, less detailed images with unrealistic features.</li></ul></li></ul></li> <li><strong>Other Tasks:</strong><ul><li><strong>GANs:</strong><ul><li><strong>Strengths:</strong> Can be used for tasks like super-resolution and image-to-image translation.</li> <li><strong>Weaknesses:</strong> May not be the best choice for tasks that require a smooth transition between data points.</li></ul></li> <li><strong>VAEs:</strong><ul><li><strong>Strengths:</strong> Widely used for tasks like image denoising and anomaly detection.</li> <li><strong>Weaknesses:</strong> May not be as effective as GANs for tasks that require high-quality image generation.</li></ul></li></ul></li>`,os,k,qs="Here’s a table summarizing the key differences:",ps,_,Vs="<thead><tr><th>Feature</th> <th>GANs</th> <th>VAEs</th></tr></thead> <tbody><tr><td>Image Quality</td> <td>Higher</td> <td>Lower</td></tr> <tr><td>Ease of Training</td> <td>More difficult</td> <td>Easier</td></tr> <tr><td>Stability</td> <td>Less Stable</td> <td>More Stable</td></tr> <tr><td>Applications</td> <td>Image Generation, Super-resolution, image-to-image translation</td> <td>Image Denoising, Anamoly Detection, Signal Analysis</td></tr></tbody>",hs,$,js="Ultimately, the best choice depends on one’s specific needs and priorities. If one needs high-quality images for tasks like generating realistic faces or landscapes, then a GAN might be the better choice. However, if one needs a model that is easier to train and more stable, then a VAE might be a better option.",cs,G,gs,T,Ws="Training GANs involves a unique adversarial process where the generator and discriminator play a cat-and-mouse game.",ds,h,H,Os="<strong>Adversarial Training Process:</strong> The generator and discriminator are trained simultaneously. The generator aims to produce data that is indistinguishable from real data, while the discriminator strives to improve its ability to differentiate between real and fake samples.",Ts,d,I,Rs="Objective Function:",Ls,us,Ys='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><munder><mrow><mi>min</mi><mo>⁡</mo></mrow><mi>G</mi></munder><munder><mrow><mi>max</mi><mo>⁡</mo></mrow><mi>D</mi></munder><mi>L</mi><mo stretchy="false">(</mo><mi>D</mi><mo separator="true">,</mo><mi>G</mi><mo stretchy="false">)</mo><mo>=</mo><msub><mi mathvariant="double-struck">E</mi><mrow><mi>x</mi><mo>∼</mo><msub><mi>p</mi><mi>r</mi></msub><mo stretchy="false">(</mo><mi>x</mi><mo stretchy="false">)</mo></mrow></msub><mo stretchy="false">[</mo><mi>log</mi><mo>⁡</mo><mi>D</mi><mo stretchy="false">(</mo><mi>x</mi><mo stretchy="false">)</mo><mo stretchy="false">]</mo><mo>+</mo><msub><mi mathvariant="double-struck">E</mi><mrow><mi>x</mi><mo>∼</mo><msub><mi>p</mi><mi>g</mi></msub><mo stretchy="false">(</mo><mi>x</mi><mo stretchy="false">)</mo></mrow></msub><mo stretchy="false">[</mo><mi>log</mi><mo>⁡</mo><mo stretchy="false">(</mo><mn>1</mn><mo>−</mo><mi>D</mi><mo stretchy="false">(</mo><mi>x</mi><mo stretchy="false">)</mo><mo stretchy="false">)</mo><mo stretchy="false">]</mo></mrow><annotation encoding="application/x-tex">\\min_G \\max_D L(D, G)=\\mathbb{E}_{x \\sim p_{r}(x)} [\\log D(x)] + \\mathbb{E}_{x \\sim p_g(x)} [\\log(1 - D(x))]</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.4943em;vertical-align:-0.7443em;"></span><span class="mop op-limits"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.6679em;"><span style="top:-2.3557em;margin-left:0em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">G</span></span></span><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span><span class="mop">min</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.7443em;"><span></span></span></span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mop op-limits"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.4306em;"><span style="top:-2.3557em;margin-left:0em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">D</span></span></span><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span><span class="mop">max</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.7443em;"><span></span></span></span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal">L</span><span class="mopen">(</span><span class="mord mathnormal" style="margin-right:0.02778em;">D</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal">G</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.1052em;vertical-align:-0.3552em;"></span><span class="mord"><span class="mord mathbb">E</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3448em;"><span style="top:-2.5198em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">x</span><span class="mrel mtight">∼</span><span class="mord mtight"><span class="mord mathnormal mtight">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1645em;"><span style="top:-2.357em;margin-left:0em;margin-right:0.0714em;"><span class="pstrut" style="height:2.5em;"></span><span class="sizing reset-size3 size1 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">r</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.143em;"><span></span></span></span></span></span></span><span class="mopen mtight">(</span><span class="mord mathnormal mtight">x</span><span class="mclose mtight">)</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3552em;"><span></span></span></span></span></span></span><span class="mopen">[</span><span class="mop">lo<span style="margin-right:0.01389em;">g</span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">D</span><span class="mopen">(</span><span class="mord mathnormal">x</span><span class="mclose">)]</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.1275em;vertical-align:-0.3775em;"></span><span class="mord"><span class="mord mathbb">E</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3448em;"><span style="top:-2.5198em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">x</span><span class="mrel mtight">∼</span><span class="mord mtight"><span class="mord mathnormal mtight">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1645em;"><span style="top:-2.357em;margin-left:0em;margin-right:0.0714em;"><span class="pstrut" style="height:2.5em;"></span><span class="sizing reset-size3 size1 mtight"><span class="mord mathnormal mtight" style="margin-right:0.03588em;">g</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2819em;"><span></span></span></span></span></span></span><span class="mopen mtight">(</span><span class="mord mathnormal mtight">x</span><span class="mclose mtight">)</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3775em;"><span></span></span></span></span></span></span><span class="mopen">[</span><span class="mop">lo<span style="margin-right:0.01389em;">g</span></span><span class="mopen">(</span><span class="mord">1</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">D</span><span class="mopen">(</span><span class="mord mathnormal">x</span><span class="mclose">))]</span></span></span></span></span>',fs,zs,D,Us="<strong>Iterative Improvement:</strong> As training progresses, the generator becomes adept at producing realistic samples, and the discriminator becomes more discerning. This adversarial loop continues until the generator generates data that is virtually indistinguishable from real data.",vs,L,ys,z,Fs='<li><a href="https://lilianweng.github.io/posts/2017-08-20-gan/" rel="nofollow">Lilian Weng’s Awesome Blog on GANs</a></li> <li><a href="https://jonathan-hui.medium.com/gan-whats-generative-adversarial-networks-and-its-application-f39ed278ef09" rel="nofollow">GAN — What is Generative Adversarial Networks</a></li> <li><a href="https://ai.stackexchange.com/questions/25601/what-are-the-fundamental-differences-between-vae-and-gan-for-image-generation" rel="nofollow">What are the fundamental differences between VAE and GAN for image generation?</a></li> <li><a href="https://stats.stackexchange.com/questions/541775/issues-with-gan-and-vae-models" rel="nofollow">Issues with GAN and VAE models</a></li> <li><a href="https://www.baeldung.com/cs/vae-vs-gan-image-generation" rel="nofollow">VAE Vs. GAN For Image Generation</a></li> <li><a href="https://towardsai.net/p/machine-learning/diffusion-models-vs-gans-vs-vaes-comparison-of-deep-generative-models" rel="nofollow">Diffusion Models vs. GANs vs. VAEs: Comparison of Deep Generative Models</a></li>',bs,C,ws,B,xs;return u=new Q({props:{title:"Generative Adversarial Networks",local:"generative-adversarial-networks",headingTag:"h1"}}),f=new Q({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),w=new Q({props:{title:"GANs vs VAEs",local:"gans-vs-vaes",headingTag:"h2"}}),G=new Q({props:{title:"Training GANs",local:"training-gans",headingTag:"h2"}}),L=new Q({props:{title:"References:",local:"references",headingTag:"h2"}}),C=new ne({props:{source:"https://github.com/huggingface/computer-vision-course/blob/main/chapters/en/unit5/generative-models/gans.mdx"}}),{c(){c=l("meta"),Y=n(),F=l("p"),X=n(),q(u.$$.fragment),Z=n(),q(f.$$.fragment),ss=n(),v=l("p"),v.innerHTML=Es,es=n(),p=l("ul"),E=l("li"),E.innerHTML=Ms,_s=n(),g=l("li"),M=l("strong"),M.textContent=Ns,$s=As(" The generator takes random noise"),ts=new Bs(!1),as=As(" as input and generates synthetic data samples. Its goal is to create data that is realistic enough to deceive the discriminator."),Gs=n(),N=l("li"),N.innerHTML=Hs,ns=n(),y=l("p"),y.textContent=Is,is=n(),b=l("p"),b.innerHTML=Ds,ls=n(),q(w.$$.fragment),rs=n(),x=l("p"),x.textContent=Ps,ms=n(),A=l("ul"),A.innerHTML=Ss,os=n(),k=l("p"),k.textContent=qs,ps=n(),_=l("table"),_.innerHTML=Vs,hs=n(),$=l("p"),$.textContent=js,cs=n(),q(G.$$.fragment),gs=n(),T=l("p"),T.textContent=Ws,ds=n(),h=l("ul"),H=l("li"),H.innerHTML=Os,Ts=n(),d=l("li"),I=l("strong"),I.textContent=Rs,Ls=As(" The training process is guided by a min-max game type objective function which is used to optimize both the generator and the discriminator. The generator aims to minimize the probability of the discriminator correctly classifying generated samples as fake, while the discriminator seeks to maximize this probability. This objective function is represented as:"),us=new Bs(!1),fs=As(`
Here, the discriminator tries to maximize this loss function whereas the generator tries to minimize it, hence the adversarial nature.`),zs=n(),D=l("li"),D.innerHTML=Us,vs=n(),q(L.$$.fragment),ys=n(),z=l("ol"),z.innerHTML=Fs,bs=n(),q(C.$$.fragment),ws=n(),B=l("p"),this.h()},l(s){const e=ae("svelte-u9bgzb",document.head);c=r(e,"META",{name:!0,content:!0}),e.forEach(t),Y=i(s),F=r(s,"P",{}),V(F).forEach(t),X=i(s),j(u.$$.fragment,s),Z=i(s),j(f.$$.fragment,s),ss=i(s),v=r(s,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1vteoh7"&&(v.innerHTML=Es),es=i(s),p=r(s,"UL",{});var P=V(p);E=r(P,"LI",{"data-svelte-h":!0}),o(E)!=="svelte-12c3p9j"&&(E.innerHTML=Ms),_s=i(P),g=r(P,"LI",{});var J=V(g);M=r(J,"STRONG",{"data-svelte-h":!0}),o(M)!=="svelte-1gdtcpl"&&(M.textContent=Ns),$s=ks(J," The generator takes random noise"),ts=Js(J,!1),as=ks(J," as input and generates synthetic data samples. Its goal is to create data that is realistic enough to deceive the discriminator."),J.forEach(t),Gs=i(P),N=r(P,"LI",{"data-svelte-h":!0}),o(N)!=="svelte-e07c60"&&(N.innerHTML=Hs),P.forEach(t),ns=i(s),y=r(s,"P",{"data-svelte-h":!0}),o(y)!=="svelte-1hb8plt"&&(y.textContent=Is),is=i(s),b=r(s,"P",{"data-svelte-h":!0}),o(b)!=="svelte-14zw7rg"&&(b.innerHTML=Ds),ls=i(s),j(w.$$.fragment,s),rs=i(s),x=r(s,"P",{"data-svelte-h":!0}),o(x)!=="svelte-ryo7sn"&&(x.textContent=Ps),ms=i(s),A=r(s,"UL",{"data-svelte-h":!0}),o(A)!=="svelte-d9myg6"&&(A.innerHTML=Ss),os=i(s),k=r(s,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1anp2nv"&&(k.textContent=qs),ps=i(s),_=r(s,"TABLE",{"data-svelte-h":!0}),o(_)!=="svelte-qvoxqx"&&(_.innerHTML=Vs),hs=i(s),$=r(s,"P",{"data-svelte-h":!0}),o($)!=="svelte-9mfent"&&($.textContent=js),cs=i(s),j(G.$$.fragment,s),gs=i(s),T=r(s,"P",{"data-svelte-h":!0}),o(T)!=="svelte-hlrzgj"&&(T.textContent=Ws),ds=i(s),h=r(s,"UL",{});var S=V(h);H=r(S,"LI",{"data-svelte-h":!0}),o(H)!=="svelte-113ifpr"&&(H.innerHTML=Os),Ts=i(S),d=r(S,"LI",{});var K=V(d);I=r(K,"STRONG",{"data-svelte-h":!0}),o(I)!=="svelte-1vgqxfx"&&(I.textContent=Rs),Ls=ks(K," The training process is guided by a min-max game type objective function which is used to optimize both the generator and the discriminator. The generator aims to minimize the probability of the discriminator correctly classifying generated samples as fake, while the discriminator seeks to maximize this probability. This objective function is represented as:"),us=Js(K,!1),fs=ks(K,`
Here, the discriminator tries to maximize this loss function whereas the generator tries to minimize it, hence the adversarial nature.`),K.forEach(t),zs=i(S),D=r(S,"LI",{"data-svelte-h":!0}),o(D)!=="svelte-w0fr8a"&&(D.innerHTML=Us),S.forEach(t),vs=i(s),j(L.$$.fragment,s),ys=i(s),z=r(s,"OL",{"data-svelte-h":!0}),o(z)!=="svelte-1mdhw80"&&(z.innerHTML=Fs),bs=i(s),j(C.$$.fragment,s),ws=i(s),B=r(s,"P",{}),V(B).forEach(t),this.h()},h(){Ks(c,"name","hf:doc:metadata"),Ks(c,"content",le),ts.a=as,us.a=fs},m(s,e){m(document.head,c),a(s,Y,e),a(s,F,e),a(s,X,e),W(u,s,e),a(s,Z,e),W(f,s,e),a(s,ss,e),a(s,v,e),a(s,es,e),a(s,p,e),m(p,E),m(p,_s),m(p,g),m(g,M),m(g,$s),ts.m(Qs,g),m(g,as),m(p,Gs),m(p,N),a(s,ns,e),a(s,y,e),a(s,is,e),a(s,b,e),a(s,ls,e),W(w,s,e),a(s,rs,e),a(s,x,e),a(s,ms,e),a(s,A,e),a(s,os,e),a(s,k,e),a(s,ps,e),a(s,_,e),a(s,hs,e),a(s,$,e),a(s,cs,e),W(G,s,e),a(s,gs,e),a(s,T,e),a(s,ds,e),a(s,h,e),m(h,H),m(h,Ts),m(h,d),m(d,I),m(d,Ls),us.m(Ys,d),m(d,fs),m(h,zs),m(h,D),a(s,vs,e),W(L,s,e),a(s,ys,e),a(s,z,e),a(s,bs,e),W(C,s,e),a(s,ws,e),a(s,B,e),xs=!0},p:Zs,i(s){xs||(O(u.$$.fragment,s),O(f.$$.fragment,s),O(w.$$.fragment,s),O(G.$$.fragment,s),O(L.$$.fragment,s),O(C.$$.fragment,s),xs=!0)},o(s){R(u.$$.fragment,s),R(f.$$.fragment,s),R(w.$$.fragment,s),R(G.$$.fragment,s),R(L.$$.fragment,s),R(C.$$.fragment,s),xs=!1},d(s){s&&(t(Y),t(F),t(X),t(Z),t(ss),t(v),t(es),t(p),t(ns),t(y),t(is),t(b),t(ls),t(rs),t(x),t(ms),t(A),t(os),t(k),t(ps),t(_),t(hs),t($),t(cs),t(gs),t(T),t(ds),t(h),t(vs),t(ys),t(z),t(bs),t(ws),t(B)),t(c),U(u,s),U(f,s),U(w,s),U(G,s),U(L,s),U(C,s)}}}const le='{"title":"Generative Adversarial Networks","local":"generative-adversarial-networks","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"GANs vs VAEs","local":"gans-vs-vaes","sections":[],"depth":2},{"title":"Training GANs","local":"training-gans","sections":[],"depth":2},{"title":"References:","local":"references","sections":[],"depth":2}],"depth":1}';function re(Cs){return se(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class he extends ee{constructor(c){super(),te(this,c,re,ie,Xs,{})}}export{he as component};
